<?php
/* --------------------------------------------------------------
 routes.php 2024-05-22
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2024 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

use Gambio\Api\Modules\ShopConfig\App\Actions\FetchShopConfigAction;
use Gambio\Api\Modules\ShopConfig\App\Actions\FetchShopConfigValueAction;
use Gambio\Core\Application\Routing\RouteCollector;

return static function (RouteCollector $routeCollector) {
    $routeCollector->get('/api.php/v3/shop-config', FetchShopConfigAction::class);
    $routeCollector->get('/api.php/v3/shop-config/{key:[A-Za-z_]+}', FetchShopConfigValueAction::class);
};
